/*
 * Decompiled with CFR 0.152.
 */
package Magicms;

import InfoDialog.InfoDialog;
import MagicRemoteState.MagicRemoteError;
import MagicRemoteState.MagicRemoteHold;
import MagicRemoteState.MagicRemoteIdle;
import MagicRemoteState.MagicRemoteInit;
import MagicRemoteState.MagicRemoteRun;
import MagicRemoteState.MagicRemoteState;
import Magicms.Repeater;
import Magicms.SemicolonProperties;
import Magicms.UnicodeStrings;
import Magicms.WerteListe;
import Options.MagicMSData;
import Options.Options;
import Utils.ErrorMessages;
import Utils.Utilities;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.filechooser.FileFilter;
import mnet.remote.DeterminationSampleData;
import mnet.remote.MagicRemoteInterface;
import mnet.remote.RemoteStateChangeListener;
import mnet.remote.RemoteStateEvent;
import mnet.remote.RemoteUserMsg;
import mnet.remote.UserMsgListener;

public class Hauptklasse
extends JFrame {
    private JPanel mainPanel;
    private JTextField txtState;
    private JLabel statusbarPanel1;
    private final JMenuItem mi_Options;
    private final JMenuItem mi_Save;
    private final JMenuItem mi_Exit;
    private final JMenuItem mi_About;
    private static Options options = null;
    private InfoDialog aboutDialog = null;
    private MagicRemoteState currentState;
    private final MagicRemoteState initState;
    private final MagicRemoteState idleState;
    private final MagicRemoteState runState;
    private final MagicRemoteState errorState;
    private final MagicRemoteState holdState;
    private static final MagicMSData MAGIC_MS_DATA = new MagicMSData();
    private Timer Polling;
    private Timer StartTimer;
    public final boolean magicInitFlag = true;
    private static boolean magicInitialised;
    public String[] Places;
    private final ErrorMessages Messages;
    public static final ArrayList methods;
    public final ArrayList methodGroupList;
    private static Logger Log;
    private static FileHandler LogHandler;
    private static String[] Argumente;
    private static Hauptklasse app;
    private static final DateFormat LOGDATEFORMATTER;
    private static Timer MessageTimer;
    private static ResourceBundle gui;
    private static String MagicPath;
    private SemicolonProperties Params;
    private boolean DoShutdown;

    private Hauptklasse(String title) {
        super(title);
        this.$$$setupUI$$$();
        this.initState = new MagicRemoteInit();
        this.idleState = new MagicRemoteIdle();
        this.runState = new MagicRemoteRun();
        this.errorState = new MagicRemoteError();
        this.holdState = new MagicRemoteHold();
        this.magicInitFlag = true;
        this.Places = new String[4];
        this.Messages = new ErrorMessages();
        this.methodGroupList = new ArrayList();
        String AllUsers = System.getenv("ALLUSERSPROFILE");
        String OS = System.getProperty("os.name");
        String App = System.getenv("APPDATA");
        String[] AppDataParts = App.split("\\\\");
        String AppData = AppDataParts[AppDataParts.length - 1];
        MagicPath = AllUsers + "\\" + AppData + "\\Metrohm\\MagicMS";
        if (OS.contains("Vista") || OS.contains("7")) {
            MagicPath = AllUsers + "\\Metrohm\\MagicMS";
        }
        Hauptklasse.initLanguage();
        this.mi_Options = new JMenuItem(Hauptklasse.prop("main.Settings"));
        this.mi_Save = new JMenuItem(Hauptklasse.prop("main.Save"));
        this.mi_Exit = new JMenuItem(Hauptklasse.prop("main.End"));
        this.mi_About = new JMenuItem(Hauptklasse.prop("main.About"));
        options = new Options(this, MagicPath, Hauptklasse.prop("main.Settings"));
        this.aboutDialog = new InfoDialog(this);
        this.addMenuBar();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Hauptklasse.this.exit();
            }
        });
        MessageTimer = new Timer(100, new Message());
        this.setContentPane(this.mainPanel);
        this.setResizable(false);
        this.pack();
        this.setBounds(50, 50, 250, 150);
        this.setDefaultCloseOperation(0);
        Hauptklasse.InitializeLogger();
        this.Params = new SemicolonProperties(Log);
        Log.info("MagicPath=" + MagicPath);
        this.StartPolling();
    }

    private String readLicense() {
        return MagicRemoteInterface.getVersion();
    }

    private void CheckIt() {
        if (!this.readLicense().startsWith("2")) {
            JOptionPane.showMessageDialog(null, "MagIC MS cannot start, because the MagIC Net version is not supported. Please install the correct version of MagIC Net.", "Error", 0);
            System.exit(1);
        }
    }

    private static void InitializeLogger() {
        try {
            LogHandler = new FileHandler(MagicPath + "\\Log.txt", 1000000, 1, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Log = Logger.getLogger("Remote.Hauptklasse");
        LogHandler.setFormatter(new SingleLineFormatter());
        Log.addHandler(LogHandler);
        Log.setFilter(new FilterAt());
        Log.log(Level.INFO, Hauptklasse.prop("msg.start"));
        options.SetLogger(Log);
    }

    private void StartPolling() {
        this.ReadINI();
        TimePrinter listener = new TimePrinter();
        magicStarter Start = new magicStarter();
        this.Polling = new Timer(1000, listener);
        this.Polling.start();
        this.StartTimer = new Timer(Hauptklasse.MAGIC_MS_DATA.StartTime, Start);
    }

    private void ReadINI() {
        try {
            options.Load();
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String stacktrace = sw.toString();
            Log.severe(stacktrace);
            JOptionPane.showMessageDialog(this, Hauptklasse.prop("msg.loaderror"), "ERROR", 0);
            Log.severe("ini File nicht gefunden!");
            System.exit(1);
            return;
        }
        options.getDialogData(MAGIC_MS_DATA);
        if (MAGIC_MS_DATA == null) {
            JOptionPane.showMessageDialog(null, "MagicMS.ini data are missing.");
        }
    }

    private static void CheckWorkplaceAfterInit() {
        if (!Utilities.WorkplaceExists(Hauptklasse.MAGIC_MS_DATA.workplace)) {
            JOptionPane.showMessageDialog(null, "The determination cannot start, because " + String.format("the workplace '%1$s' does not exist.\r\nPlease create this workplace and restart the determination.", Hauptklasse.MAGIC_MS_DATA.workplace), "Error", 0);
            Log.log(Level.SEVERE, "Workplace does not exist:" + Hauptklasse.MAGIC_MS_DATA.workplace);
        }
    }

    private static void initLanguage() {
        gui = ResourceBundle.getBundle("GUI_en");
    }

    private static String prop(String key) {
        return gui.getString(key);
    }

    private void addMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu(Hauptklasse.prop("main.File"));
        this.mi_Options.addActionListener(new Mi_OptionsEvent());
        fileMenu.add(this.mi_Options);
        this.mi_Save.addActionListener(new Mi_SaveEvent());
        fileMenu.add(this.mi_Save);
        this.mi_Exit.addActionListener(new Mi_ExitEvent());
        fileMenu.add(this.mi_Exit);
        menuBar.add(fileMenu);
        JMenu infoMenu = new JMenu(Hauptklasse.prop("main.Info"));
        infoMenu.add(this.mi_About);
        this.mi_About.addActionListener(new Mi_InfoEvent());
        menuBar.add(infoMenu);
        this.setJMenuBar(menuBar);
    }

    private void SendErrorToClient() {
        this.changeControlState(this.errorState);
        Log.log(Level.WARNING, " *************** ERROR !!! **************** ");
        Log.log(Level.WARNING, this.Messages.Errortitle);
        Log.log(Level.WARNING, this.Messages.Errorcode);
        Log.log(Level.WARNING, this.Messages.Errortext);
        Log.log(Level.WARNING, this.Messages.Errortip);
    }

    void startDetermination() {
        Log.log(Level.INFO, "EventType = startDeterm");
        Repeater SecureStart = new Repeater();
        String[] ID = new String[4];
        String[] V = new String[4];
        String Ident = Hauptklasse.MAGIC_MS_DATA.ident;
        String Method = Hauptklasse.MAGIC_MS_DATA.method;
        int Type2 = Hauptklasse.MAGIC_MS_DATA.sampletype;
        int Level2 = Hauptklasse.MAGIC_MS_DATA.callevel;
        String SampleType = this.getSampleType(Type2, Level2);
        String Workplace = Hauptklasse.MAGIC_MS_DATA.workplace;
        String Amount = Hauptklasse.MAGIC_MS_DATA.amount;
        String Dilution = Hauptklasse.MAGIC_MS_DATA.dilution;
        String Volume = Hauptklasse.MAGIC_MS_DATA.volume;
        String Injections = "1";
        String Pos = Integer.toString(Hauptklasse.MAGIC_MS_DATA.position);
        for (int i = 0; i < 4; ++i) {
            ID[i] = Hauptklasse.MAGIC_MS_DATA.info[i];
            V[i] = Hauptklasse.MAGIC_MS_DATA.value[i];
        }
        if (!this.isStartable(Workplace)) {
            return;
        }
        DeterminationSampleData detSampleData = new DeterminationSampleData();
        Hauptklasse.setDeterminationInfos(detSampleData, ID);
        Hauptklasse.setValueInfos(detSampleData, V);
        Hauptklasse.setAmountInfos(detSampleData, Amount, Dilution, Ident, Injections, Pos, SampleType, Volume);
        MagicRemoteInterface.getWorkplaceCtrl().setDeterminationSampleData(Workplace, detSampleData);
        Log.info("--- Methodenstart: " + Method + " auf Arbeitsplatz " + Workplace);
        SecureStart.startDetermMultiple(Workplace, Method, detSampleData, 1);
        this.DoShutdown = Hauptklasse.MAGIC_MS_DATA.Shutdown;
        this.ReadINI();
    }

    private String getSampleType(int type, int level) throws ArrayIndexOutOfBoundsException {
        String Probentyp = Hauptklasse.MAGIC_MS_DATA.SampleTypeNames[type - 1];
        if (level > 0) {
            Probentyp = Probentyp + " " + level;
        }
        Log.info("type=" + type + " level=" + level + "Probentyp = " + Probentyp);
        return Probentyp;
    }

    void doOptionsDialog() {
        try {
            options.Load();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, Hauptklasse.prop("msg.loaderror"), "ERROR", 0);
        }
        if (options.showDialog()) {
            options.getDialogData(MAGIC_MS_DATA);
            this.setVisible(Hauptklasse.MAGIC_MS_DATA.Visible);
            if (Hauptklasse.MAGIC_MS_DATA.AutoInit && !magicInitialised) {
                MagicRemoteInterface.init((String[])Argumente);
            }
            if (MagicRemoteInterface.getGUICtrl() != null) {
                Hauptklasse.SetMagicVisibility();
            }
        }
    }

    void exit() {
        LogHandler.flush();
        Runnable shutDownRunnable = new Runnable(){

            @Override
            public void run() {
                if (MagicRemoteInterface.shutdown()) {
                    System.exit(0);
                }
            }
        };
        if (this.currentState == null) {
            System.exit(0);
        }
        Thread shutDownThread = new Thread(shutDownRunnable);
        shutDownThread.setName("RemoteShutDownThread");
        shutDownThread.start();
    }

    void changeControlState(MagicRemoteState newState) {
        this.currentState = newState;
        this.txtState.setText(newState.stateText);
        this.txtState.setBackground(newState.stateColor);
    }

    void changeGuiState(boolean state) {
        this.mi_Options.setEnabled(state);
    }

    void init(String[] args) {
        Log.info("args[0]=" + args[0]);
        Log.info("args[1]=" + args[1]);
        String[] Triple = new String[]{args[0], args[1], args[2]};
        Log.info("args[2]=" + Triple[2]);
        this.changeControlState(this.initState);
        this.changeGuiState(false);
        this.statusbarPanel1.setText(Hauptklasse.prop("msg.init"));
        MagicRemoteInterface.init((String[])Triple);
        this.CheckIt();
        MagicRemoteInterface.setHideFrameOnExit((boolean)false);
        MagicRemoteInterface.getWorkplaceCtrl().addRemoteStateChangeListener((RemoteStateChangeListener)new RemoteStateListener());
        Hauptklasse.SetMagicVisibility();
        this.Places = MagicRemoteInterface.getWorkplaceCtrl().getControlNames();
        if (this.Places.length > 0) {
            this.changeControlState(this.idleState);
            for (String Place : this.Places) {
                options.addWorkplace(Place);
                this.changeGuiState(true);
            }
        } else {
            JOptionPane.showMessageDialog(null, Hauptklasse.prop("msg.noworkplace"), Hauptklasse.prop("msg.error"), 0);
            this.changeControlState(this.errorState);
            this.changeGuiState(false);
        }
        this.statusbarPanel1.setText(Hauptklasse.MAGIC_MS_DATA.workplace);
        magicInitialised = true;
    }

    private static void SetMagicVisibility() {
        switch (Hauptklasse.MAGIC_MS_DATA.windowStyle) {
            case 1: {
                MagicRemoteInterface.getGUICtrl().showFrame();
                MagicRemoteInterface.getGUICtrl().restoreFrame();
                break;
            }
            case 2: {
                MagicRemoteInterface.getGUICtrl().showFrame();
                MagicRemoteInterface.getGUICtrl().minimizeFrame();
                break;
            }
            case 3: {
                MagicRemoteInterface.getGUICtrl().hideFrame();
            }
        }
    }

    private static void CareForArguments(String[] args) {
        int i;
        int MutexIndex = 1;
        String Path2 = "";
        for (i = 0; i < args.length; ++i) {
            if (!args[i].endsWith("\\")) continue;
            MutexIndex = i + 1;
        }
        for (i = 0; i < MutexIndex; ++i) {
            Path2 = Path2 + args[i] + " ";
        }
        Hauptklasse.Argumente[0] = Path2 = Path2.substring(0, Path2.length() - 1);
        Hauptklasse.Argumente[1] = args[MutexIndex];
        Hauptklasse.Argumente[2] = "0x0";
    }

    public static void main(String[] args) {
        Argumente = new String[3];
        Hauptklasse.CareForArguments(args);
        if (Argumente[1].equals("0")) {
            Hauptklasse.StartError();
            System.exit(0);
        }
        Utilities.setLookAndFeel();
        app = new Hauptklasse("SP09-01 MagIC MS");
        app.setVisible(Hauptklasse.MAGIC_MS_DATA.Visible);
        magicInitialised = false;
        if (Hauptklasse.MAGIC_MS_DATA.AutoInit) {
            Hauptklasse.MagicInit();
        }
    }

    private static void StartError() {
        JOptionPane.showMessageDialog(null, "MagIC MS cannot start, because MagIC Net is already running.\r\n Please close MagIC Net and restart MagIC MS.", "Error", 0);
        System.exit(0);
    }

    private static void MagicInit() {
        app.init(Argumente);
        app.ErrorHandling();
        Utilities.setInstance(app);
        Utilities.MethodList();
        Hauptklasse.CheckWorkplaceAfterInit();
    }

    private void ReadParamFile(String CorrectFileName) {
        Log.info("param.txt found!");
        String Value = UnicodeStrings.uni_Value;
        String Info = UnicodeStrings.uni_Info;
        try {
            int i;
            this.Params.load(MagicPath + "\\" + CorrectFileName);
            if (this.doesKeyExist(this.Params, "MagICNetwindow")) {
                Hauptklasse.MAGIC_MS_DATA.windowStyle = Options.getVisibilityFromString(this.Params.getProperty("MagICNetwindow"));
                Hauptklasse.SetMagicVisibility();
            }
            if (this.doesKeyExist(this.Params, UnicodeStrings.uni_SampleAmount)) {
                Hauptklasse.MAGIC_MS_DATA.amount = this.Params.getProperty(UnicodeStrings.uni_SampleAmount);
            }
            if (this.doesKeyExist(this.Params, UnicodeStrings.uni_Dilution)) {
                Hauptklasse.MAGIC_MS_DATA.dilution = this.Params.getProperty(UnicodeStrings.uni_Dilution);
            }
            if (this.doesKeyExist(this.Params, UnicodeStrings.uni_Ident)) {
                Hauptklasse.MAGIC_MS_DATA.ident = this.Params.getProperty(UnicodeStrings.uni_Ident);
            }
            for (i = 0; i < 4; ++i) {
                if (!this.doesKeyExist(this.Params, Info + (i + 1))) continue;
                Hauptklasse.MAGIC_MS_DATA.info[i] = this.Params.getProperty(Info + (i + 1));
            }
            if (this.doesKeyExist(this.Params, UnicodeStrings.uni_Method)) {
                Hauptklasse.MAGIC_MS_DATA.method = this.Params.getProperty(UnicodeStrings.uni_Method);
            }
            if (this.doesKeyExist(this.Params, UnicodeStrings.uni_Vial)) {
                Hauptklasse.MAGIC_MS_DATA.position = Integer.parseInt(this.Params.getProperty(UnicodeStrings.uni_Vial));
            }
            if (this.doesKeyExist(this.Params, UnicodeStrings.uni_SampleType)) {
                Hauptklasse.MAGIC_MS_DATA.sampletype = Options.getSampleTypeFromString(this.Params.getProperty(UnicodeStrings.uni_SampleType));
                Hauptklasse.MAGIC_MS_DATA.callevel = Options.getCalLevelFromString(this.Params.getProperty(UnicodeStrings.uni_SampleType));
            }
            if (this.doesKeyExist(this.Params, UnicodeStrings.uni_Shutdown)) {
                Hauptklasse.MAGIC_MS_DATA.Shutdown = Hauptklasse.StrToBool(this.Params.getProperty(UnicodeStrings.uni_Shutdown));
            }
            for (i = 0; i < 4; ++i) {
                if (!this.doesKeyExist(this.Params, Value + (i + 1))) continue;
                Hauptklasse.MAGIC_MS_DATA.value[i] = this.Params.getProperty(Value + (i + 1));
            }
            if (this.doesKeyExist(this.Params, UnicodeStrings.uni_InjVolume)) {
                Hauptklasse.MAGIC_MS_DATA.volume = this.Params.getProperty(UnicodeStrings.uni_InjVolume);
            }
            if (this.doesKeyExist(this.Params, UnicodeStrings.uni_Workplace)) {
                Hauptklasse.MAGIC_MS_DATA.workplace = this.Params.getProperty(UnicodeStrings.uni_Workplace);
            }
        }
        catch (FileNotFoundException fe) {
            Log.warning("File not found: param.txt");
        }
        catch (IOException ie) {
            Log.warning("IOException: param.txt");
        }
        catch (NumberFormatException ne) {
            Log.warning("NumberFormatException: param.txt");
        }
        File Param = new File(MagicPath + "\\" + CorrectFileName);
        if (!Param.delete()) {
            JOptionPane.showMessageDialog(null, "The file 'param.txt' could not be deleted!");
        }
    }

    private static boolean StrToBool(String s) {
        return s.equals("1");
    }

    private boolean doesKeyExist(SemicolonProperties sp, String key) {
        return sp.doesKeyExist(key);
    }

    private void doSave() {
        WerteListe VL = new WerteListe();
        JFileChooser Chooser = new JFileChooser();
        Chooser.setFileFilter(new TextFilter());
        Chooser.showSaveDialog(this);
        if (Chooser.getSelectedFile() == null) {
            return;
        }
        String filename = Chooser.getSelectedFile().getPath();
        if (!filename.endsWith(".txt")) {
            filename = filename + ".txt";
        }
        try {
            VL.SaveToFile(filename);
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(this, Hauptklasse.prop("msg.errorsave"), Hauptklasse.prop("msg.error"), 0);
        }
    }

    private void ErrorHandling() {
        MagicRemoteInterface.getUserMsgCtrl().setReceiveAllUserMessages(false);
        MagicRemoteInterface.getUserMsgCtrl().setParentForAllMessages((Component)this);
        MagicRemoteInterface.getUserMsgCtrl().setUserMsgListener(new UserMsgListener(){

            public int userMsgReceived(RemoteUserMsg remoteUserMsg) {
                ((Hauptklasse)Hauptklasse.this).Messages.Errortitle = remoteUserMsg.getMsgTitle();
                ((Hauptklasse)Hauptklasse.this).Messages.Errorcode = remoteUserMsg.getMsgRef();
                ((Hauptklasse)Hauptklasse.this).Messages.Errortext = remoteUserMsg.getMsgText();
                ((Hauptklasse)Hauptklasse.this).Messages.Errortip = remoteUserMsg.getMsgTip();
                Log.info("\u00a7 User Message! " + remoteUserMsg.getMsgText());
                if (!MessageTimer.isRunning()) {
                    MessageTimer.start();
                }
                return 0;
            }
        });
    }

    private boolean isStartable(String workplace) {
        if (!Utilities.WorkplaceExists(workplace)) {
            JOptionPane.showMessageDialog(null, "The determination cannot start, because " + String.format("the workplace '%1$s' does not exist.\r\nPlease create this workplace and restart the determination.", workplace), "Error", 0);
            Log.log(Level.SEVERE, "Workplace does not exist:" + workplace);
            return false;
        }
        String Status = MagicRemoteInterface.getWorkplaceCtrl().getControlState(workplace);
        if (!Status.equals("READY") && !Status.equals("")) {
            JOptionPane.showMessageDialog(null, "The determination cannot start, because " + String.format("the workplace '%1$s' is already running.\r\nPlease wait until this workplace is ready and restart the determination.", workplace), "Error", 0);
            Log.severe("Workplace is already running:" + workplace);
            return false;
        }
        return true;
    }

    private static void setDeterminationInfos(DeterminationSampleData d, String[] ids) {
        d.setSampleData(201, ids[0]);
        d.setSampleData(202, ids[1]);
        d.setSampleData(203, ids[2]);
        d.setSampleData(204, ids[3]);
        Log.info("Info[1] = " + ids[0]);
        Log.info("Info[2] = " + ids[1]);
        Log.info("Info[3] = " + ids[2]);
        Log.info("Info[4] = " + ids[3]);
    }

    private static void setValueInfos(DeterminationSampleData d, String[] values) {
        d.setSampleData(205, values[0]);
        d.setSampleData(206, values[1]);
        d.setSampleData(207, values[2]);
        d.setSampleData(208, values[3]);
        Log.info("Values[1] = " + values[0]);
        Log.info("Values[2] = " + values[1]);
        Log.info("Values[3] = " + values[2]);
        Log.info("Values[4] = " + values[3]);
    }

    private static void setAmountInfos(DeterminationSampleData d, String amo, String dil, String ide, String inj, String pos, String typ, String vol) {
        if (amo == null) {
            Log.severe("NULL: amount");
            amo = " ";
        }
        if (dil == null) {
            Log.severe("NULL: dilution");
            dil = " ";
        }
        if (ide == null) {
            Log.severe("NULL: ident");
            ide = " ";
        }
        if (inj == null) {
            Log.severe("NULL: inj");
            inj = " ";
        }
        if (pos == null) {
            Log.severe("NULL: pos");
            pos = " ";
        }
        if (typ == null) {
            Log.severe("NULL: typ");
            typ = " ";
        }
        if (vol == null) {
            Log.severe("NULL: volume");
            vol = " ";
        }
        d.setSampleData(215, amo);
        d.setSampleData(214, dil);
        d.setSampleData(209, ide);
        d.setSampleData(212, inj);
        d.setSampleData(211, pos);
        d.setSampleData(210, typ);
        d.setSampleData(213, vol);
        Log.info("Amount = " + amo);
        Log.info("Dilution = " + dil);
        Log.info("Ident = " + ide);
        Log.info("Injections = " + inj);
        Log.info("SamplePos = " + pos);
        Log.info("SampleType = " + typ);
        Log.info("SampleVolume = " + vol);
    }

    static {
        methods = new ArrayList();
        LOGDATEFORMATTER = new SimpleDateFormat("dd.MM.yyyy - HH:mm:ss");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JLabel jLabel;
        JPanel jPanel;
        this.mainPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(2, 2, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 1, 3, 3, 0, null, new Dimension(150, 75), null));
        this.statusbarPanel1 = jLabel = new JLabel();
        jLabel.setHorizontalTextPosition(2);
        jLabel.setText("not defined");
        jLabel.setHorizontalAlignment(2);
        jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("GUI").getString("main.Workplace"));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("GUI").getString("main.State"));
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.txtState = jTextField = new JTextField();
        jTextField.setHorizontalAlignment(2);
        jTextField.setEditable(false);
        jPanel2.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, new Dimension(80, -1), new Dimension(80, -1), new Dimension(80, -1)));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static class SingleLineFormatter
    extends Formatter {
        private SingleLineFormatter() {
        }

        @Override
        public String format(LogRecord rec) {
            StringBuffer message = new StringBuffer();
            try {
                message.append(LOGDATEFORMATTER.format(new Date(rec.getMillis())));
                message.append(": ");
                message.append(rec.getLevel());
                message.append(' ');
                message.append(rec.getMessage());
                message.append("\r\n");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return message.toString();
        }
    }

    private static class TextFilter
    extends FileFilter {
        private TextFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.getName().toLowerCase().endsWith(".txt") || f.isDirectory();
        }

        @Override
        public String getDescription() {
            return "Textfiles";
        }
    }

    private class magicStarter
    implements ActionListener {
        private magicStarter() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Hauptklasse.this.StartTimer.stop();
            Hauptklasse.this.startDetermination();
            Log.log(Level.INFO, "Determination started" + System.currentTimeMillis());
            Hauptklasse.this.Polling.start();
        }
    }

    private class TimePrinter
    implements ActionListener {
        private TimePrinter() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean Found = false;
            String FileName = null;
            String RealPath = MagicPath;
            File PathName = new File(RealPath);
            String[] fileNames = PathName.list();
            if (fileNames != null) {
                for (String fileName : fileNames) {
                    File TXTFile;
                    File f = new File(PathName.getPath(), fileName);
                    if (!f.isFile() || !(FileName = (TXTFile = f).getName()).toLowerCase().endsWith("param.txt")) continue;
                    Found = true;
                    Log.info("*** param.txt ist da !! ***");
                    break;
                }
            }
            if (fileNames == null) {
                return;
            }
            if (fileNames.length == 0) {
                return;
            }
            if (!Found) {
                return;
            }
            Hauptklasse.this.ReadParamFile(FileName);
            Hauptklasse.this.StartTimer.start();
            Log.log(Level.INFO, "StartTimer gestartet" + System.currentTimeMillis());
        }
    }

    private class RemoteStateListener
    implements RemoteStateChangeListener {
        private RemoteStateListener() {
        }

        public void remoteStateChanged(RemoteStateEvent e) {
            if (!magicInitialised) {
                return;
            }
            if (e.getCommand() == 0) {
                String controlState = e.getControlState();
                if (controlState.equals("BUSY")) {
                    Hauptklasse.this.changeControlState(Hauptklasse.this.runState);
                } else if (controlState.equals("READY")) {
                    Hauptklasse.this.changeControlState(Hauptklasse.this.idleState);
                    Log.info("READY");
                    if (Hauptklasse.this.DoShutdown) {
                        MagicRemoteInterface.getWorkplaceCtrl().stopHardware(MAGIC_MS_DATA.workplace);
                        Log.info("shutdown hardware on " + MAGIC_MS_DATA.workplace);
                    }
                } else if (controlState.equals("ERROR")) {
                    Log.severe("Status = ERROR");
                } else if (controlState.equals("HOLD")) {
                    Hauptklasse.this.changeControlState(Hauptklasse.this.holdState);
                } else if (controlState.equals("")) {
                    // empty if block
                }
            }
        }
    }

    private class Mi_SaveEvent
    implements ActionListener {
        private Mi_SaveEvent() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Hauptklasse.this.doSave();
        }
    }

    private class Mi_OptionsEvent
    implements ActionListener {
        private Mi_OptionsEvent() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Hauptklasse.this.doOptionsDialog();
        }
    }

    private class Mi_InfoEvent
    implements ActionListener {
        private Mi_InfoEvent() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Hauptklasse.this.aboutDialog.setVisible(true);
        }
    }

    private class Mi_ExitEvent
    implements ActionListener {
        private Mi_ExitEvent() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Hauptklasse.this.exit();
        }
    }

    private class Message
    implements ActionListener {
        private Message() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MessageTimer.stop();
            if (MagicRemoteInterface.getUserMsgCtrl().isReceiveAllUserMessages()) {
                Hauptklasse.this.SendErrorToClient();
            }
        }
    }

    private static class FilterAt
    implements Filter {
        private FilterAt() {
        }

        @Override
        public boolean isLoggable(LogRecord record) {
            return true;
        }
    }
}

